/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.VI;

import com.quantumdata.VI.CharIcon;
import com.quantumdata.VI.GenButtonHandler;
import com.quantumdata.VI.VIPlugInApplet;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class LcdDevice {
    private static final int COLUMNS = 20;
    private static final int ROWS = 4;
    private static final Font lcdFont = new Font("Monospaced", 1, 22);
    private static final Dimension LINEDIM = new Dimension(300, 20);
    private static final int VERTICAL_SPACE = 24;
    private static final Point ORIGIN = new Point(170, 104);
    private static final char BASE_SPECIAL_CHAR = '~';
    private JButton[] m_blueButton = new JButton[8];
    private ImageIcon m_backgroundIcon;
    private JLabel m_background;
    private JLayeredPane m_mainPane;
    private JLabel[] m_row = new JLabel[4];
    private String[] m_rawText = new String[4];
    private CharIcon[][] m_rowIcons = new CharIcon[4][2];
    private CharIcon m_topIcon;
    private CharIcon m_bottomIcon;
    private CharIcon m_cursorIcon;
    private Point m_cursor;
    public static final Color vfdColor = new Color(40, 255, 100);

    public void init(RemoteInstrument remoteInstrument) {
        Cloneable cloneable;
        int n;
        this.m_cursor = new Point(ORIGIN);
        this.m_backgroundIcon = QDUtil.createAppletImageIcon("images/LCDdisplayBlank.gif", VIPlugInApplet.class);
        ImageIcon imageIcon = QDUtil.createAppletImageIcon("images/BlueButtonLeft.gif", VIPlugInApplet.class);
        ImageIcon imageIcon2 = QDUtil.createAppletImageIcon("images/BlueButtonLeftPress.gif", VIPlugInApplet.class);
        ImageIcon imageIcon3 = QDUtil.createAppletImageIcon("images/BlueButtonRight.gif", VIPlugInApplet.class);
        ImageIcon imageIcon4 = QDUtil.createAppletImageIcon("images/BlueButtonRightPress.gif", VIPlugInApplet.class);
        this.m_background = new JLabel(this.m_backgroundIcon);
        this.m_background.setOpaque(true);
        this.m_background.setSize(this.m_backgroundIcon.getIconWidth(), this.m_backgroundIcon.getIconHeight());
        this.m_mainPane = new JLayeredPane();
        this.m_mainPane.setPreferredSize(this.m_background.getSize());
        this.m_mainPane.add((Component)this.m_background, JLayeredPane.DEFAULT_LAYER);
        Point point = new Point(ORIGIN);
        for (n = 0; n < 4; ++n) {
            this.m_row[n] = new JLabel();
            this.m_row[n].setSize(LINEDIM);
            this.m_row[n].setLocation(point);
            this.m_row[n].setFont(lcdFont);
            this.m_row[n].setForeground(vfdColor);
            this.m_mainPane.add((Component)this.m_row[n], JLayeredPane.PALETTE_LAYER);
            this.m_rawText[n] = new String(" ");
            this.m_rowIcons[n] = new CharIcon[2];
            this.m_rowIcons[n][0] = new CharIcon(0, ORIGIN);
            this.m_rowIcons[n][1] = new CharIcon(0, ORIGIN);
            this.m_rowIcons[n][0].setLocation(new Point(point));
            this.m_mainPane.add((Component)this.m_rowIcons[n][0], JLayeredPane.MODAL_LAYER);
            cloneable = new Point(point);
            ((Point)cloneable).translate(247, 0);
            this.m_rowIcons[n][1].setLocation(new Point((Point)cloneable));
            this.m_mainPane.add((Component)this.m_rowIcons[n][1], JLayeredPane.MODAL_LAYER);
            point.translate(0, 24);
        }
        this.m_topIcon = new CharIcon(0, ORIGIN);
        this.m_bottomIcon = new CharIcon(0, ORIGIN);
        this.m_cursorIcon = new CharIcon(0, ORIGIN);
        this.m_cursorIcon.setXY(0, 0);
        this.m_mainPane.add((Component)this.m_cursorIcon, JLayeredPane.MODAL_LAYER);
        this.m_topIcon.setXY(9, 0);
        this.m_mainPane.add((Component)this.m_topIcon, JLayeredPane.MODAL_LAYER);
        this.m_bottomIcon.setXY(9, 3);
        this.m_mainPane.add((Component)this.m_bottomIcon, JLayeredPane.MODAL_LAYER);
        cloneable = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        Point point2 = new Point(18, 50);
        point = new Point(point2);
        String string = new String("Selects adjacent item on LCD");
        int[] nArray = new int[]{3, 2, 1, 0, 7, 6, 5, 4};
        for (n = 0; n < 8; ++n) {
            JButton jButton;
            if (n < 4) {
                jButton = new JButton(imageIcon);
                jButton.setPressedIcon(imageIcon2);
            } else {
                jButton = new JButton(imageIcon3);
                jButton.setPressedIcon(imageIcon4);
            }
            jButton.setFocusPainted(false);
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setEnabled(true);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setSize((Dimension)cloneable);
            jButton.setToolTipText(string);
            GenButtonHandler genButtonHandler = new GenButtonHandler(remoteInstrument, nArray[n]);
            jButton.setMnemonic(49 + n);
            jButton.addActionListener(genButtonHandler);
            jButton.addMouseListener(genButtonHandler);
            jButton.setLocation(point);
            if (n == 3) {
                point.setLocation(point2);
                point.translate(467, 0);
            } else {
                point.translate(0, 48);
            }
            this.m_mainPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
            this.m_blueButton[n] = jButton;
        }
    }

    public JLayeredPane getPane() {
        return this.m_mainPane;
    }

    public void clear() {
        for (int i = 0; i < 4; ++i) {
            this.m_rawText[i] = "";
            this.m_row[i].setText(" ");
        }
        this.setLocation(0, 0);
    }

    public void setLocation(int n, int n2) {
        this.m_cursor.setLocation(n, n2);
    }

    public void print(String string) {
    }

    public String getRow(int n) {
        return this.m_row[n].getText();
    }

    public void setRow(int n, String string) {
        this.m_row[n].setText(string);
    }

    public void updateDisplay(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.clear();
        while (n2 < 4) {
            n = string.indexOf("\n", n3);
            if (n < 0) {
                return;
            }
            this.m_rawText[n2++] = string.substring(n3, n);
            n3 = n + 1;
        }
        n = string.indexOf(",", n3);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(n3, n);
        int n4 = Integer.parseInt(string2);
        string2 = string.substring(n + 1);
        int n5 = Integer.parseInt(string2);
        this.m_topIcon.setXY(-1, -1);
        this.m_bottomIcon.setXY(-1, -1);
        this.m_topIcon.setType(0);
        this.m_bottomIcon.setType(0);
        for (n2 = 0; n2 < 4; ++n2) {
            this.m_rowIcons[n2][0].setType(0);
            this.m_rowIcons[n2][1].setType(0);
            this.m_rowIcons[n2][0].setXY(-1, -1);
            this.m_rowIcons[n2][1].setXY(-1, -1);
            StringBuffer stringBuffer = new StringBuffer(this.m_rawText[n2]);
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (!this.isSpecial(c)) continue;
                if (i == 0) {
                    this.m_rowIcons[n2][0].setType(c);
                    this.m_rowIcons[n2][0].setXY(i, n2);
                } else if (i == 19) {
                    this.m_rowIcons[n2][1].setType(c);
                    this.m_rowIcons[n2][1].setXY(i, n2);
                } else if (n2 == 0) {
                    this.m_topIcon.setType(c);
                    this.m_topIcon.setXY(i, n2);
                } else if (n2 == 3) {
                    this.m_bottomIcon.setType(c);
                    this.m_bottomIcon.setXY(i, n2);
                }
                stringBuffer.setCharAt(i, ' ');
            }
            this.m_row[n2].setText(stringBuffer.toString());
        }
        if (n4 >= 0) {
            this.m_cursorIcon.setType(1);
            this.m_cursorIcon.setXY(n4, n5);
        } else {
            this.m_cursorIcon.setType(0);
            this.m_cursorIcon.setXY(-1, -1);
        }
    }

    private boolean isSpecial(char c) {
        return c >= '~';
    }
}

